const fs = require('fs');
const { body, validationResult } = require("express-validator");

class system {

	constructor() {
		//do nothing
	}

	controller(string, newConstructor=true) {
		const split = string.split(":");
		const method = split[1] || "";
		const file = split[0];

		let path = `../app/controllers/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./controllers/${file}.js`;
		}
		const __controller = require(path);
		const __system = new system();
		return __controller[method](__system);
	}

	config(file, newConstructor=true) {
		let path = `../app/configs/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./configs/${file}.js`;
		}

		const __class = require(path);
		return newConstructor ? new __class() : __class;
	}

	lang(file, _var, ...params) {
		try {
			let path = `../app/languages/${file}.js`;
			if (!fs.existsSync(`${__dirname}/${path}`)) {
				path = `./languages/${file}.js`;
			}

			const __class = require(path);
			var str = __class[_var];
			params.forEach((v, k) => {
				str = str.replaceAll(new RegExp(`\\{${k}\\}`,"gi"), v);
			});
			return str;
		} catch (err) {
			console.log(err);
			return '';
		}
	}

	helper(file, newConstructor=false) {
		let path = `../app/helpers/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./helpers/${file}.js`;
		}

		const __class = require(path);
		return newConstructor ? new __class() : __class;
	}

	validation(string, newConstructor=false) {
		const split = string.split(":");
		const method = split[1] || "";
		const file = split[0];

		let path = `../app/validations/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./validations/${file}.js`;
		}
		const __validation = require(path);
		const __system = new system();
		__system.body = body;
		__system.validationResult = validationResult;
		const validations = __validation[method](__system);
		validations.push(function(req, res, next) {
			const validate = validationResult(req);
			req.validate = validate;
			if(!validate.isEmpty()) {
				req.validate.get_errors = function() {
					const errors = new Object();
					req.validate.array().map(function(v, k){
						errors[v.param] = v.msg;
					});
					return errors;
				}
			}
			next();
		});
		return validations;
	}

	library(file, newConstructor=true) {
		let path = `../app/libraries/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./libraries/${file}.js`;
		}

		const __class = require(path);
		return newConstructor ? new __class() : __class;
	}

	service(file, newConstructor=true) {
		let path = `../app/services/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./services/${file}.js`;
		}

		const __class = require(path);
		return newConstructor ? new __class() : __class;
	}

	model(file, newConstructor=true) {
		let path = `../app/models/${file}.js`;
		if (!fs.existsSync(`${__dirname}/${path}`)) {
			path = `./models/${file}.js`;
		}

		const __class = require(path);
		return newConstructor ? new __class() : __class;
	}

	filter(...params) {
		let functions = [];
		params.map((string) => {
			const split = string.split(":");
			const file = split[0];
			let parameters = [];
			if(split.length > 1) {
				split.shift();
				parameters = split;
			}

			let path = `../app/filters/${file}.js`;
			if (!fs.existsSync(`${__dirname}/${path}`)) {
				path = `./filters/${file}.js`;
			}
			const __filter = require(path);
			const __system = new system();
			functions.push( __filter(__system, ...parameters) );
		});
		return functions;
	}

	base_url(url="") {
		const config = this.config('app');
		const base_url = config.base_url.replace(/^\/+|\/+$/g, '');
		const url_to = url.replace(/^\/+|\/+$/g, '');
		return `${base_url}/${url_to}`;
	}

}

module.exports = system;