const whatsapp = require('../libraries/whatsapp.js')
const zevents = require('../libraries/zevents.js')
const moment = require('moment');
const deviceModel = require('../models/devices.js');
const messageModel = require('../models/messages.js');
const autoreplyModel = require('../models/autoreplies.js');
const userModel = require('../models/users.js');
const webhookModel = require('../models/webhooks.js');
const uniqid = require('uniqid');
const axios = require('axios');

module.exports = class {

	static devices = new Map();

	static startAll = async function() {
		const $ = this;
		const model = new deviceModel();
		model.batchUpdate([], {status_sub: 'Disconnected'});
		const devices = await model.findAll([
			['where', 'status', '=', 'active']
		]);

		devices.forEach((val, key) => {
			$.register(val);
		});
	}

	static get = function(session) {
		return this.devices.get(session);
	}

	static isJsonString = function(str) {
	    try {
	        JSON.parse(str);
	    } catch (e) {
	        return false;
	    }
	    return true;
	}

	static register = function(device) {
		const $ = this;
		const code = device.session;
		console.log(code);
		if(typeof this.devices.get(code) == 'undefined') {
			const mDevice = new deviceModel();
			const mMsg = new messageModel();
			const mUser = new userModel();
			const mAutoRep = new autoreplyModel();
			const wh = new webhookModel();

			console.log(`|- ${moment().format('DD/MM/YYYY HH:mm:ss')} -|`);
			console.log(`registering instance: ${code}`);
			console.log(`|-----------------------|`);

			const instance = new whatsapp({session: code});
			const ev = new zevents();
			
			this.devices.set(code, {...instance, ...ev, ...device});
			device = this.devices.get(code);

			mUser.findOne([
				['where', 'id', '=', device.user_id]
			]).then(user => {

				instance.events.on('connecting', async function(){
					ev.emit('connecting');

					mDevice.batchUpdate([
						['where', 'session', '=', code]
					], {status_sub: 'Connecting'});

					// webhook begin ------------------------

					if(device.webhook_url && device.webhook_url.length > 10) {
						let data_params = {session_id: device.session, event: 'connection', status: 'connecting'};

						let [wh_id] = await wh.insert({
							device_id: device.id,
							url: device.webhook_url,
							data: JSON.stringify(data_params),
							event: 'connection',
							status: 'Pending',
						});

						axios.post(device.webhook_url, data_params, {api_key: user.api_key})
						.then(function (response) {
							if($.isJsonString(response)) {
								wh.update(wh_id, {
									status: 'Success',
									response: JSON.stringify(response)
								})
							} else {
								wh.update(wh_id, {
									status: 'Success',
									response: response.toString(),
								})
							}
						})
						.catch(function (error) {
							if($.isJsonString(error)) {
								wh.update(wh_id, {
									status: 'Fail',
									response: JSON.stringify(error)
								})
							} else {
								wh.update(wh_id, {
									status: 'Fail',
									response: error.toString(),
								})
							}
						});
					}
					// webhook finish ------------------------
				});
				
				instance.events.on('connected', async function(){
					ev.emit('connected');
					
					mDevice.batchUpdate([
						['where', 'session', '=', code]
					], {status_sub: 'Connected'});

					// webhook begin ------------------------

					if(device.webhook_url && device.webhook_url.length > 10) {
						let data_params = {session_id: device.session, event: 'connection', status: 'connected'};

						let [wh_id] = await wh.insert({
							device_id: device.id,
							url: device.webhook_url,
							data: JSON.stringify(data_params),
							event: 'connection',
							status: 'Pending',
						});

						axios.post(device.webhook_url, data_params, {api_key: user.api_key})
						.then(function (response) {
							if($.isJsonString(response)) {
								wh.update(wh_id, {
									status: 'Success',
									response: JSON.stringify(response)
								})
							} else {
								wh.update(wh_id, {
									status: 'Success',
									response: response.toString(),
								})
							}
						})
						.catch(function (error) {
							if($.isJsonString(error)) {
								wh.update(wh_id, {
									status: 'Fail',
									response: JSON.stringify(error)
								})
							} else {
								wh.update(wh_id, {
									status: 'Fail',
									response: error.toString(),
								})
							}
						});
					}
					// webhook finish ------------------------
				});
				
				instance.events.on('disconnected', async function(){
					ev.emit('disconnected');
					
					mDevice.batchUpdate([
						['where', 'session', '=', code]
					], {status_sub: 'Disconnected'});

					// webhook begin ------------------------

					if(device.webhook_url && device.webhook_url.length > 10) {
						let data_params = {session_id: device.session, event: 'connection', status: 'disconnected'};

						let [wh_id] = await wh.insert({
							device_id: device.id,
							url: device.webhook_url,
							data: JSON.stringify(data_params),
							event: 'connection',
							status: 'Pending',
						});

						axios.post(device.webhook_url, data_params, {api_key: user.api_key})
						.then(function (response) {
							if($.isJsonString(response)) {
								wh.update(wh_id, {
									status: 'Success',
									response: JSON.stringify(response)
								})
							} else {
								wh.update(wh_id, {
									status: 'Success',
									response: response.toString(),
								})
							}
						})
						.catch(function (error) {
							if($.isJsonString(error)) {
								wh.update(wh_id, {
									status: 'Fail',
									response: JSON.stringify(error)
								})
							} else {
								wh.update(wh_id, {
									status: 'Fail',
									response: error.toString(),
								})
							}
						});
					}
					// webhook finish ------------------------
				});
				
				instance.events.on('qr', async function(qr){
					ev.emit('qr', qr);
					
					mDevice.batchUpdate([
						['where', 'session', '=', code]
					], {status_sub: 'QR Code'});

					// webhook begin ------------------------
					if(device.webhook_url && device.webhook_url.length > 10) {
						let data_params = {session_id: device.session, event: 'qr', qrcode: qr};

						let [wh_id] = await wh.insert({
							device_id: device.id,
							url: device.webhook_url,
							data: JSON.stringify(data_params),
							event: 'qr',
							status: 'Pending',
						});

						axios.post(device.webhook_url, data_params, {api_key: user.api_key})
						.then(function (response) {
							if($.isJsonString(response)) {
								wh.update(wh_id, {
									status: 'Success',
									response: JSON.stringify(response)
								})
							} else {
								wh.update(wh_id, {
									status: 'Success',
									response: response.toString(),
								})
							}
						})
						.catch(function (error) {
							if($.isJsonString(error)) {
								wh.update(wh_id, {
									status: 'Fail',
									response: JSON.stringify(error)
								})
							} else {
								wh.update(wh_id, {
									status: 'Fail',
									response: error.toString(),
								})
							}
						});
					}
					// webhook finish ------------------------
				});
				
				instance.events.on('send_message', async function(m){
					if(m.status == 'sent') {
						mMsg.update(m.id, {status: m.status, sended_at: new Date()});
					} else {
						mMsg.update(m.id, {status: m.status});
					}

					// webhook begin ------------------------
					if(device.webhook_url && device.webhook_url.length > 10) {
						let data_params = {session_id: device.session, event: 'message', type: "out", status: m.status, msg_code: m.code, phone: m.phone.replaceAll(/[^0-9]/gi, ''), message: m.message};

						let [wh_id] = await wh.insert({
							device_id: device.id,
							url: device.webhook_url,
							data: JSON.stringify(data_params),
							event: 'message',
							status: 'Pending',
						});

						axios.post(device.webhook_url, data_params, {api_key: user.api_key})
						.then(function (response) {
							if($.isJsonString(response)) {
								wh.update(wh_id, {
									status: 'Success',
									response: JSON.stringify(response)
								})
							} else {
								wh.update(wh_id, {
									status: 'Success',
									response: response.toString(),
								})
							}
						})
						.catch(function (error) {
							if($.isJsonString(error)) {
								wh.update(wh_id, {
									status: 'Fail',
									response: JSON.stringify(error)
								})
							} else {
								wh.update(wh_id, {
									status: 'Fail',
									response: error.toString(),
								})
							}
						});
					}
					// webhook finish ------------------------
				});

				instance.events.on('stop', async function(){
					mDevice.batchUpdate([
						['where', 'session', '=', code]
					], {status_sub: 'Disconnected'});
					$.devices.delete(code);
				});
				
				instance.events.on('receive_message', async function(m){
					try {
						const [phone] = m.key.remoteJid.match(/^(.*?)(?=@)/gi);
						const message = m.message?.conversation;

						if(phone && message) {
							mMsg.insert({
								type: 'In',
								device_id: device.id,
								phone: phone,
								message: message,
								media_url: '-',
								media_type: 'text',
								sended_at: new Date(),
								send_at: new Date(),
								status: 'sent'
							});

							// webhook begin ------------------------
					
							if(device.webhook_url && device.webhook_url.length > 10) {
								let data_params = {session_id: device.session, event: 'message', type: "in", phone: phone, message: message};

								let [wh_id] = await wh.insert({
									device_id: device.id,
									url: device.webhook_url,
									data: JSON.stringify(data_params),
									event: 'message',
									status: 'Pending',
								});

								axios.post(device.webhook_url, data_params, {api_key: user.api_key})
								.then(function (response) {
									if($.isJsonString(response)) {
										wh.update(wh_id, {
											status: 'Success',
											response: JSON.stringify(response)
										})
									} else {
										wh.update(wh_id, {
											status: 'Success',
											response: response.toString(),
										})
									}
								})
								.catch(function (error) {
									if($.isJsonString(error)) {
										wh.update(wh_id, {
											status: 'Fail',
											response: JSON.stringify(error)
										})
									} else {
										wh.update(wh_id, {
											status: 'Fail',
											response: error.toString(),
										})
									}
								});
							}
							// webhook finish ------------------------
						}
					} catch (err) {
						console.log(err);
					}
				});

				// register pending messages
				mMsg.findAll([
					['where', 'device_id', '=', device.id],
					['where', 'type', '=', 'Out'],
					['where', 'status', '=', 'pending']
				]).then(messages => {
					messages.forEach((val, key) => {
						instance.send_message({
							id: val.id,
							type: val.media_type,
							phone: val.phone,
							message: val.message,
							url: val.media_url,
							send_at: val.send_at
						});
					});
				});

				// register auto replies
				mAutoRep.findAll([
					['where', 'status', 'Active'],
					['where', 'device_id', device.id]
				]).then(function(m){
					device.setAutoReplies(m);
				}).catch(function(er){
					console.log(er);
				});
			}).catch(err => {
				console.log(err);
			});
			return instance;
		}
	}

}